{include file="mheader.tpl"}
<!-- Extra Header -->
    <div class="extraHeader pe-0 ps-0">
        <ul class="nav nav-tabs lined" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#waiting" role="tab">
                    Ask for withdrawal
                </a>
            </li>
            
        </ul>
    </div>
    <!-- * Extra Header -->

<br><br>
 <!-- App Capsule -->
    <div id="appCapsule">


        

 

{if $say eq 'processed'}
{if $batch eq ''}
<div class="alert alert-imaged alert-success alert-dismissible fade show" role="alert">
Withdrawal request has been successfully saved.{else} Withdrawal has been processed. Batch id: {$batch}{/if}
</div>

{/if}

{if $fatals}
  {if $fatal == 'times_limit' || $fatals.times_limit}
  <div class="alert alert-imaged alert-success alert-dismissible fade show" role="alert">You can withdraw {$settings.limit_withdraw_period_times} per {$settings.limit_withdraw_period_date} only.</div>
  {/if}

{else}
{if $say eq 'ec_forbidden' || $errors.ec_forbidden}
<div class="alert alert-imaged alert-success alert-dismissible fade show" role="alert">
Sorry, withdraw for this processing is temproary forbidden.<br><br></div>
{/if}
{if $say eq 'on_hold' || $errors.on_hold}
<div class="alert alert-imaged alert-success alert-dismissible fade show" role="alert">
Sorry, this amount on hold now.<br><br></div>
{/if}
{if $say eq 'zero' || $errors.zero}
Sorry, you can't request a withdraw smaller than {$currency_sign}0.00 only<br><br>
{/if}
{if $say eq 'less_min' || $errors.less_min}
Sorry, you can request not less than {$currency_sign}{*$settings.min_withdrawal_amount*}{$fees.amount_min}<br><br>
{/if}
{if $say eq 'greater_max' || $errors.greater_max}
Sorry, you can request not greater than {$currency_sign}{*$settings.max_withdrawal_amount*}{$fees.amount_max}<br><br>
{/if}
{if $say eq 'daily_limit' || $errors.daily_limit}
Sorry, you have exceeded a daily limit<br><br>
{/if}
{if $say eq 'not_enought' || $errors.not_enought}
Sorry, you have requested the amount larger than the one on your balance.<br><br>
{/if}
{if $say eq 'invalid_transaction_code' || $errors.invalid_transaction_code}
You have entered the invalid transaction code.<br><br>
{/if}
{if $say eq 'invalid_tfa_code' || $errors.invalid_tfa_code}
You have entered invalid 2FA code.<br><br>
{/if}
{if $say eq 'no_deposits' || $errors.no_deposits}
You have not done any deposits yet. Withdrawal function will be available after a deposit.
<br><br>
{/if}
{if $say eq 'no_active_deposits' || $errors.no_active_deposits}
You must have active deposit to withdraw.
{/if}
{if $say eq 'no_account' || $errors.no_account}
Please, provide your account to withdraw funds to first <a href="{"?a=edit_account"|encurl}">here</a>.
{/if}
{if $errors.demo}
Withdraw is not available for demo account.
{/if}
{if $errors.turing_image}Invalid turing image{/if}
{if $errors.account_suspended}Account is suspended{/if}

{if $preview}
<br><br>
<form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=withdraw>
<input type=hidden name=amount value={$amount}>
<input type=hidden name=ec value={$ec}>
<input type=hidden name=comment value="{$comment|escape:html}">

<table id="customers" cellspacing=0 cellpadding=2 border=0 class="form deposit_confirm">
<tr>
 <th>Payment System:</th>
 <td>{$currency}</td>
</tr>
<tr>
 <th>Account:</th>
 <td>{$account}</td>
</tr>
<tr>
 <th>Debit Amount:</th>
 <td>{$amount|fiat:$ec}</td>
</tr>
<tr>
 <th>Withdrawal Fee:</th>
 <td>
{if $fees.fee > 0}
  {$fees.percent}% + {$fees.add_amount|fiat:$ec} (min. {$fees.fee_min|fiat:$ec} max. {if $fees.fee_max}{$fees.fee_max|fiat:$ec}{else}no{/if})
{else}
We have no fee for this operation.
{/if}
</td>
</tr>

{if $converted}
<tr>
 <th>Credit Amount:</th>
 <td>{$converted.amount|fiat:$ec}</td>
</tr>
<tr>
 <th>{$converted.fiat} Amount:</th>
 <td>{$to_withdraw}</td>
</tr>
{else}
<tr>
 <th>Credit Amount:</th>
 <td>{$to_withdraw|fiat:$ec}</td>
</tr>
{/if}

{if $comment}
<tr>
 <th>Note:</th>
 <td>{$comment|escape:html}</td>
</tr>
{/if}
{if $settings.use_transaction_code && $userinfo.transaction_code}
<tr>
 <th>Transaction Code:</th>
 <td><input type="password" name="transaction_code" class=inpts size=15></td>
</tr>
{/if}
{include file="captcha.tpl" action="withdrawal"}
{if $userinfo.tfa_settings.withdraw}
<tr>
 <th>2FA Code:</th>
 <td><input type="text" name="tfa_code" class=inpts size=15> <input type="hidden" name="tfa_time" id="tfa_time"></td>
</tr>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}
<tr>
 <td colspan=2><input type=submit value="Confirm" class="btn btn-primary btn-lg btn-block"></td>
</tr></table>
</form>


{else}

<div class="section mt-2">
            
            <div class="card">
                <div class="card-body">

                   

                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="userid1">Account Balance</label>
                                <input type="text" disabled class="form-control"   placeholder="{$currency_sign}{$ab_formated.total}">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="amount1">Pending Withdrawals</label>
                                <input type="text" disabled class="form-control"  placeholder="{$currency_sign}{if $ab_formated.withdraw_pending != 0}{$ab_formated.withdraw_pending|amount_format}{/if}">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        

                </div>
            </div>
        </div>



<!-- History -->
        <div class="section mt-4">
            <div class="section-heading">
                <h2 class="title">Balance History</h2>
                 
            </div>
            <div class="card">
                <ul class="listview flush transparent no-line image-listview detailed-list mt-1 mb-1">
                    {assign var="wfch" value=1}
                    {foreach from=$ps item=p}
                    <!-- item -->
                    <li>
                        <a href="#" class="item">
                            <div class="icon-box bg-success">
                               <img src="images/{$p.id}.gif" width=44 height=17 align=absmiddle>
                            </div>
                            <div class="in">
                                <div>
                                    <strong>{$p.name|escape:html}</strong>
                                    <div class="text-small text-secondary">Pending</div>
                                </div>
                                <div class="text-end"style="color:green">
                                    <strong>{$p.available|fiat:$p.ec}</strong>
                                    <div class="text-small"style="color:red">
                                        {$p.pending|fiat:$p.ec}
                                    </div>
                                </div>
                            </div>
                        </a>
                    </li>
                    <!-- * item -->
                    {/foreach}
</div>
</div>

<!-- * History -->

<div class="section mt-4">
{if $have_available}


<div class="card">
                <div class="card-body">

                    <button type="button" data-bs-toggle="modal" data-bs-target="#depositActionSheet" class="btn btn-primary btn-lg btn-block">Withdraw Now</button>

                </div>
            </div>
{else}
<div class="card">
                <div class="card-body">

                    <button  class="btn btn-danger btn-lg btn-block">You have no funds to withdraw.</button>

                </div>
            </div>
 

{/if}

</div>
 <!-- Deposit Action Sheet -->
        <div class="modal fade action-sheet" id="depositActionSheet" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Process Withdrawal</h5>
                    </div>
                    <div class="modal-body">
                        <div class="action-sheet-content">
                            <form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=preview>
<input type=hidden name=say value="">
                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="account1">Select Payment</label>
                                        <select name="ec"  class="form-control custom-select" id="account1">
                                            <option value="0">Select Payment</option>
                                            {foreach from=$ps item=p}
                                            <option value="{$p.id}">{$p.name|escape:html}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <label class="label">Enter Amount</label>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text" id="basic-addona1">({$currency_sign})</span>
                                        <input type="text" name=amount value="{$frm.amount|amount_format|default:"10.00"}" class="form-control" 
                                             >
                                             
                                             <textarea hidden name=comment class=inpts cols=45 rows=4>Your comment</textarea>
                                    </div>
                                </div>


                                <div class="form-group basic">
                                    <button type="submit" class="btn btn-primary btn-block btn-lg" >Continue</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Deposit Action Sheet --

<form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=preview>
<input type=hidden name=say value="">

<table cellspacing=0 cellpadding=2 border=0>
<tr>
 <td>Account Balance:</td>
 <td>{$currency_sign}<b>{$ab_formated.total}</b></td>
</tr>
<tr>
 <td>Pending Withdrawals: </td>
 <td>{$currency_sign}<b>{if $ab_formated.withdraw_pending != 0}{$ab_formated.withdraw_pending|amount_format}{/if}</b></td>
</tr>
</table>

<table cellspacing=0 cellpadding=2 border=0>
<tr>
 <th></th>
 <th>Processing</th>
 <th>Available</th>
{if $have_hold}
 <th>On Hold</th>
{/if}
 <th>Pending</th>
 <th>Account</th>
</tr>
{assign var="wfch" value=1}
{foreach from=$ps item=p}
<tr>
 <td>{if $p.available > 0}<input type="radio" name="ec" value="{$p.id}" {if $frm.ec == $p.id || $wfch}{assign var="wfch" value=0}checked{/if}>{/if}</td>
 <td><img src="images/{$p.id}.gif" width=44 height=17 align=absmiddle> {$p.name|escape:html}</td>
 <td><b style="color:green">{$p.available|fiat:$p.ec}</b></td>
{if $have_hold}
 <td><b style="color:gray">{$p.hold|fiat:$p.ec}</b></td>
{/if}
 <td><b style="color:red">{$p.pending|fiat:$p.ec}</b></td>
 <td>{if $p.account != ''}{$p.account|escape:html}{else}<a href="{"?a=edit_account"|encurl}"><i>not set</i></a>{/if}</td>
</tr>
{/foreach}
</table>

{if $have_available}
<table cellspacing=0 cellpadding=2 border=0 width=200>
<tr>
 <td colspan=2>&nbsp;</td>
</tr>
<tr>
 <td>Withdrawal ({$currency_sign}):</td>
 <td><input type=text name=amount value="{$frm.amount|amount_format|default:"10.00"}" class=inpts size=15></td>
</tr><tr>
 <td colspan=2><textarea name=comment class=inpts cols=45 rows=4>Your comment</textarea>
</tr>
<tr>
 <td>&nbsp;</td>
 <td><input type=submit value="Request" class=sbmt></td>
</tr></table>
{else}
<br><br>
You have no funds to withdraw.
{/if}
</form>
-->
{/if}

{/if}
  </div>
    <!-- * App Capsule -->
{include file="mfooter.tpl"}